define([
    'modules/page/popup/warning-popup-view',
    'text!modules/new-appointment-request/views/common/cancel-modal/template.html',
], function(WarningPopupView, template) {
    'use strict';


    /**
     * @class CancelConfirmModel
     * @typedef {Backbone.View<Backbone.Model>}
     */
    return WarningPopupView.extend({
        id: 'cancel-confirmation',
        template: template,
        continue: function() {
            var entryType;

            this.trigger('continue');
            if (typeof gas !== 'undefined') {
                entryType = this.model.get('entryType');
                gas('send', 'event', 'veteran-appointment', 'user-cancelled-appointment-request', entryType);
            }

            if (this.options.onContinue) {
                this.options.onContinue();
            }
        },
    });
});
